package com.handheld.KeyTest;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Bundle;
import android.view.KeyEvent;
import android.widget.TextView;
import android.widget.Toast;

import com.handheld.apiinstructions.R;

public class KeyTestActivity extends Activity {
	TextView tvKeyLeft;
	TextView tvKeyRight;
	TextView tvKeyVol;
	TextView tvKeyPower;
	TextView tvKeyf1;
	TextView tvKeyf2;
	TextView tvKeyf3;
	TextView tvKeyf4;

    private KeyReceiver keyReceiver;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_keytest_c9);
		initView();
		registerReceiver();
	}

	private void registerReceiver() {
		keyReceiver = new KeyReceiver();
		IntentFilter filter = new IntentFilter();
		filter.addAction("android.rfid.FUN_KEY");
		registerReceiver(keyReceiver , filter);
	}
	private void unregisterReceiver(){
		unregisterReceiver(keyReceiver);
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		unregisterReceiver();
	}

	private void initView() {
		tvKeyLeft = (TextView) findViewById(R.id.left_key);
		tvKeyRight = (TextView) findViewById(R.id.right_key);
		tvKeyVol = (TextView) findViewById(R.id.vol_key);
		tvKeyPower = (TextView) findViewById(R.id.power_key);
		tvKeyf1 = (TextView) findViewById(R.id.f1_key);
		tvKeyf2 = (TextView) findViewById(R.id.f2_key);
		tvKeyf3 = (TextView) findViewById(R.id.f3_key);
		tvKeyf4 = (TextView) findViewById(R.id.f4_key);
	}

	int count = 0 ;
	private static Toast toast;

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (toast==null) {
			toast = Toast.makeText(KeyTestActivity.this, "onKeyDown:keyCode = " + keyCode, Toast.LENGTH_SHORT);
		} else {
			toast.setText("onKeyDown:keyCode = " + keyCode);
		}
		toast.show();
		switch (keyCode) {
		case 0://
			break;
		case 24:
			tvKeyVol.setBackgroundColor(Color.YELLOW);
			break;
		case 26:
			tvKeyPower.setBackgroundColor(Color.YELLOW);
			break;
		default:
			break;
		}
		return super.onKeyDown(keyCode, event);
	}

	private class KeyReceiver extends BroadcastReceiver {

		@Override
		public void onReceive(Context context, Intent intent) {
			int keyCode = intent.getIntExtra("keyCode", 0);
			if (keyCode == 0) {
				keyCode = intent.getIntExtra("keycode", 0);
			}
			boolean keyDown = intent.getBooleanExtra("keydown", false);
			if (keyDown) {
				if (toast == null) {
					toast = Toast.makeText(KeyTestActivity.this, "KeyReceiver:keyCode = " + keyCode, Toast.LENGTH_SHORT);
				} else {
					toast.setText("KeyReceiver:keyCode = " + keyCode);
				}
				toast.show();
				switch (keyCode) {
					case KeyEvent.KEYCODE_F1:
						tvKeyf1.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_F2:
						tvKeyf2.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_F3:
						tvKeyf3.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_F4:
						tvKeyf4.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_F5:
						tvKeyLeft.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_F6:
						tvKeyRight.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_VOLUME_UP:
						tvKeyVol.setBackgroundColor(Color.YELLOW);
						break;
					case KeyEvent.KEYCODE_POWER:
						tvKeyPower.setBackgroundColor(Color.YELLOW);
						break;
				}
			}


		}
	}
}
